<?php

namespace Database\Seeders;
use DateTime;

use Illuminate\Database\Seeder;
use App\Models\Taxonomies\Skill;
use Illuminate\Support\Facades\DB;
use App\Models\Gig\GigDeliveryTime;
use App\Models\Taxonomies\Language;
use App\Models\Taxonomies\ExpertLevel;
use App\Models\Taxonomies\GigCategory;
use App\Models\Taxonomies\ProjectCategory;
use App\Models\Taxonomies\ProjectDuration;
use App\Models\Taxonomies\ProjectLocation;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class TaxonomiesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->defaultProjectLocation();
        $this->deliveryTime();
        $this->gigCategories();
        $this->projectCategories();
        $this->projectDurations();
        $this->defaultexpertLevel();
        $this->defaultLanguages();
        $this->defaultSkills();
        $this->projectLocations();
    }

    public function defaultProjectLocation(){
        $locations = ['Onsite', 'Partially remotely','Remotely'];
        
        foreach($locations as $location){
            $check = ProjectLocation::where('name', $location)->exists();
            if(!$check){
                ProjectLocation::create([
                    'name'      => $location,
                    'status'    => 'active',
                ]);
            }
        }
    }

        /**
     * Add defualt delivery time seeder values.
     */
    public function deliveryTime(){
        GigDeliveryTime::truncate();
        
        $delivery_times = [
            1 => __('general.delivery_time_opt_1'),
            2 => __('general.delivery_time_opt_2'),
            3 => __('general.delivery_time_opt_3'),
            4 => __('general.delivery_time_opt_4'),
            5 => __('general.delivery_time_opt_5'),
            6 => __('general.delivery_time_opt_6'),
            7 => __('general.delivery_time_opt_7'),
        ];
        $record = [];
        
        foreach($delivery_times as $value => $time){
            $record[] = [
                'name'      => $time,
                'days'      => $value,
                'status'    => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ];
        }
        GigDeliveryTime::insert($record);
    }


    /**
     * Project categories
     */
    public function projectCategories(){
        ProjectCategory::truncate();
        $categories = [
            [//1
                 'parent_id'     => null,
                 'name'          => 'Digital marketing',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-1.webp')),
                 'slug'          => 'digital-marketing',
                 'description'   => "Digital Marketing",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [//2
                 'parent_id'     => 1,
                 'name'          => 'Ads Campaign',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-2.webp')),
                 'slug'          => 'ads-campaign',
                 'description'   => "Ads Campaign",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //3
                 'parent_id'     => 2,
                 'name'          => 'Google Ads',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-3.webp')),
                 'slug'          => 'google-ads',
                 'description'   => "Google Ads",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //4
                 'parent_id'     => 2,
                 'name'          => 'Meta Ads',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-4.webp')),
                 'slug'          => 'meta-ads',
                 'description'   => "Meta Ads",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //5
                 'parent_id'     => 1,
                 'name'          => 'Analytics & Strategy',		
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-5.webp')),
                 'slug'          => 'analytics-and-strategy'	,
                 'description'   => "Analytics & Strategy",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //6
                 'parent_id'     => 5,
                 'name'          => 'Content Editing',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-6.webp')),
                 'slug'          => 'content-editing',
                 'description'   => "Content Editing",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ // 7
                 'parent_id'     => null,
                 'name'          => 'AI Services',		
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-7.webp')),
                 'slug'          => 'ai-services'	,
                 'description'   => "AI Services",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ // 8
                 'parent_id'     => 7,
                 'name'          => 'AI Artists',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-8.webp')),
                 'slug'          => 'ai-artists',
                 'description'   => "AI Artists",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ // 9
                 'parent_id'     => 8,
                 'name'          => 'DALL-E',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-9.webp')),
                 'slug'          => 'dall-e',
                 'description'   => "DALL-E",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ // 10
                 'parent_id'     => 8,
                 'name'          => 'Midjourney',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-10.webp')),
                 'slug'          => 'midjourney',
                 'description'   => "Midjourney",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ // 11
                 'parent_id'     => 7,
                 'name'          => 'AI Content',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-11.webp')),
                 'slug'          => 'ai-content',
                 'description'   => "AI Content",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
 
             [ //12
                 'parent_id'     => 11,
                 'name'          => 'Ahref',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-12.webp')),
                 'slug'          => 'ahref',
                 'description'   => "Ahref",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //13
                 'parent_id'     => 11,
                 'name'          => 'Semrush',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-13.webp')),
                 'slug'          => 'semrush',
                 'description'   => "Semrush",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //14
                 'parent_id'     => 11,
                 'name'          => 'On-page seo',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-14.webp')),
                 'slug'          => 'on-page',
                 'description'   => "On-page seo",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //15
                 'parent_id'     => null,
                 'name'          => 'Graphics & design',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-15.webp')),
                 'slug'          => 'graphics-and-design',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //16
                 'parent_id'     => 15,
                 'name'          => '3D Design',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-1.webp')),
                 'slug'          => '3d-design',
                 'description'   => "3D Design",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //17
                 'parent_id'     => null,
                 'name'          => 'Health and sports',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-2.webp')),
                 'slug'          => 'health-and-sports',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //18
                 'parent_id'     => null,
                 'name'          => 'Writing & Translation',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-3.webp')),
                 'slug'          => 'writing-and-translation',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //19
                 'parent_id'     => 18,
                 'name'          => 'Career Writing',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-4.webp')),
                 'slug'          => 'career-writing',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //20
                 'parent_id'     => 18,
                 'name'          => 'Content Writing',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-5.webp')),
                 'slug'          => 'content-writing',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //21
                 'parent_id'     => 30,
                 'name'          => 'Photo Sharing',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-6.webp')),
                 'slug'          => 'photo-sharing',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //22
                 'parent_id'     => 30,
                 'name'          => 'Video Sharing',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-7.webp')),
                 'slug'          => 'video-sharing',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //23
                 'parent_id'     => null,
                 'name'          => 'Programming & Tech',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-8.webp')),
                 'slug'          => 'programming-and-tech',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //24
                 'parent_id'     => 23,
                 'name'          => 'App Development',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-9.webp')),
                 'slug'          => 'app-development',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //25
                 'parent_id'     => 24,
                 'name'          => 'Android App',
                 'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-10.webp')),
                 'slug'          => 'android-app',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //26
                'parent_id'     => null,
                'name'          => 'Video & animation',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-11.webp')),
                'slug'          => 'video-and-animation',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //27
                'parent_id'     => 26,
                'name'          => 'Video Editing',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-12.webp')),
                'slug'          => 'video-editing',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //28
                'parent_id'     => 26,
                'name'          => '3D product animation',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-13.webp')),
                'slug'          => '3d-product-animation',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //29
                'parent_id'     => null,
                'name'          => 'Music & Audio',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-14.webp')),
                'slug'          => 'music-and-audio',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //30
                'parent_id'     => 29,
                'name'          => 'Audio Engineering',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-15.webp')),
                'slug'          => 'audio-engineering',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //31
                'parent_id'     => 23,
                'name'          => 'Blockchain',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-1.webp')),
                'slug'          => 'blockchain',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //32
                'parent_id'     => 23,
                'name'          => 'Game Development',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-2.webp')),
                'slug'          => 'game-development',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //33
                'parent_id'     => 18,
                'name'          => 'eBook Publishing',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-3.webp')),
                'slug'          => 'eBook-publishing',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //34
                'parent_id'     => 15,
                'name'          => 'Art & Illustration',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-4.webp')),
                'slug'          => 'art-and-illustration',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //35
                'parent_id'     => 15,
                'name'          => 'Logo and Identity',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-5.webp')),
                'slug'          => 'logo-and-identity',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //36
                'parent_id'     => 7,
                'name'          => 'AI Data',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-5.webp')),
                'slug'          => 'ai-data',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //37
                'parent_id'     => 5,
                'name'          => 'Waterfall project management',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-6.webp')),
                'slug'          => 'waterfall-project-management',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //38
                'parent_id'     => 5,
                'name'          => 'Agile project management',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-7.webp')),
                'slug'          => 'agile-project-management',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //39
                'parent_id'     => 1,
                'name'          => 'Channel',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-8.webp')),
                'slug'          => 'channel',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //40
                'parent_id'     => 26,
                'name'          => 'Adobe after effects',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-9.webp')),
                'slug'          => 'adobe-after-effects',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //41
                'parent_id'     => 29,
                'name'          => 'Music Production',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-10.webp')),
                'slug'          => 'music-productio',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //42
                'parent_id'     => 29,
                'name'          => 'Sound Design',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-11.webp')),
                'slug'          => 'sound-design',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //43
                'parent_id'     => 36,
                'name'          => 'AI Data',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-5.webp')),
                'slug'          => 'ai-data',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //44
                'parent_id'     => 39,
                'name'          => 'Channel',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-8.webp')),
                'slug'          => 'channel',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [//45
                'parent_id'     => 1,
                'name'          => 'Search',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-2.webp')),
                'slug'          => 'search',
                'description'   => "Search",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [//46
                'parent_id'     => 1,
                'name'          => 'Social Media',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-2.webp')),
                'slug'          => 'social-media',
                'description'   => "Social Media",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [//47
                'parent_id'     => 46,
                'name'          => 'Media Marketing',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-2.webp')),
                'slug'          => 'media-marketing',
                'description'   => "Media Marketing",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ // 48
                'parent_id'     => 7,
                'name'          => 'AI Development',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-8.webp')),
                'slug'          => 'ai-development',
                'description'   => "AI Development",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ // 49
                'parent_id'     => 48,
                'name'          => 'Integrations',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-8.webp')),
                'slug'          => 'integrations',
                'description'   => "Integrations",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ // 50
                'parent_id'     => 7,
                'name'          => 'AI Video',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-8.webp')),
                'slug'          => 'ai-video',
                'description'   => "AI Video",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ], 
            [ // 51
                'parent_id'     => 50,
                'name'          => 'Spokesperson',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-8.webp')),
                'slug'          => 'spokesperson',
                'description'   => "Spokesperson",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ // 52
                'parent_id'     => 50,
                'name'          => 'Video Art',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-8.webp')),
                'slug'          => 'video-art',
                'description'   => "Video Art",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //53
                'parent_id'     => 16,
                'name'          => 'Architecture',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-1.webp')),
                'slug'          => 'architecture',
                'description'   => "Architecture",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //54
                'parent_id'     => 16,
                'name'          => 'Fashion & Garment',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-1.webp')),
                'slug'          => 'fashion-and-garment',
                'description'   => "Fashion & Garment",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //55
                'parent_id'     => 34,
                'name'          => 'Pattern Design',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-4.webp')),
                'slug'          => 'pattern-design',
                'description'   => "Pattern Design",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //56
                'parent_id'     => 15,
                'name'          => 'Marketing Design',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-1.webp')),
                'slug'          => 'marketing-design',
                'description'   => "Marketing Design",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //57
                'parent_id'     => 15,
                'name'          => 'Web & App Design',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-1.webp')),
                'slug'          => 'web-and-app-design',
                'description'   => "Web & App Design",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //58
                'parent_id'     => 56,
                'name'          => 'Social Media Design',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-1.webp')),
                'slug'          => 'social-media-design',
                'description'   => "Social Media Design",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //59
                'parent_id'     => 56,
                'name'          => 'Web Banners',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-1.webp')),
                'slug'          => 'web-banners',
                'description'   => "Web Banners",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //60
                'parent_id'     => 57,
                'name'          => 'App Design',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-1.webp')),
                'slug'          => 'app-design',
                'description'   => "App Design",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //61
                'parent_id'     => 57,
                'name'          => 'Website Design',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-1.webp')),
                'slug'          => 'website-design',
                'description'   => "Website Design",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //62
                'parent_id'     => 18,
                'name'          => 'Marketing Copy',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-3.webp')),
                'slug'          => 'marketing-copy',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //63
                'parent_id'     => 18,
                'name'          => 'Script Translation',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-3.webp')),
                'slug'          => 'script-translation',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //64
                'parent_id'     => 23,
                'name'          => 'Software Development',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-2.webp')),
                'slug'          => 'software-development',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //65
                'parent_id'     => 23,
                'name'          => 'Website Development',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-2.webp')),
                'slug'          => 'website-development',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //66
                'parent_id'     => 29,
                'name'          => 'Streaming',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-11.webp')),
                'slug'          => 'streaming',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //67
                'parent_id'     => 29,
                'name'          => 'Voice Over',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-11.webp')),
                'slug'          => 'voice-over',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //68
                'parent_id'     => 41,
                'name'          => 'Composers',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-10.webp')),
                'slug'          => 'composers',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //69
                'parent_id'     => 41,
                'name'          => 'Producers',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-10.webp')),
                'slug'          => 'producers',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //70
                'parent_id'     => 67,
                'name'          => 'Female/male Voice Over',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-11.webp')),
                'slug'          => 'female-male-voice-over',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //71
                'parent_id'     => 20,
                'name'          => 'Articles',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-5.webp')),
                'slug'          => 'articles',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //72
                'parent_id'     => 33,
                'name'          => 'eBook Editing',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-3.webp')),
                'slug'          => 'eBook-editing',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //73
                'parent_id'     => 31,
                'name'          => 'E-wallet Development',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-1.webp')),
                'slug'          => 'e-wallet-development',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //74
                'parent_id'     => 31,
                'name'          => 'Exchange Platforms',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-1.webp')),
                'slug'          => 'exchange-platforms',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //75
                'parent_id'     => 32,
                'name'          => 'Console Games',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-2.webp')),
                'slug'          => 'console-gamese',
                'description'   => "Console Games",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //76
                'parent_id'     => 64,
                'name'          => 'Desktop Applications',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-2.webp')),
                'slug'          => 'desktop-applications',
                'description'   => "Desktop Applications",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //77
                'parent_id'     => 64,
                'name'          => 'Web Applications',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-2.webp')),
                'slug'          => 'web-applications',
                'description'   => "Web Applications",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //78
                'parent_id'     => 65,
                'name'          => 'E-Commerce',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-2.webp')),
                'slug'          => 'e-commerce',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //79
                'parent_id'     => 65,
                'name'          => 'Landing Pages',
                'image'         => serialize( uploadDemoImage('posts','project-categories', 'post-2.webp')),
                'slug'          => 'landing-pages',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
         ];

        ProjectCategory::insert($categories);
    }

    /**
     * Add defualt gig categories seeder values.
     */
    public function gigCategories(){
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        GigCategory::truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        $categories = [
            [//1
                 'parent_id'     => null,
                 'name'          => 'Business Development',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'business-development',
                 'description'   => "Business development",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [//2
                 'parent_id'     => 1,
                 'name'          => 'E-commerce',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'e-commerce',
                 'description'   => "Financial consulting",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //3
                 'parent_id'     => 2,
                 'name'          => 'Product research',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'product-research',
                 'description'   => "Personal finance & wealth management",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //4
                 'parent_id'     => 2,
                 'name'          => 'Store management',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'store-management',
                 'description'   => "Financial forecasting & modeling",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //5
                 'parent_id'     => 1,
                 'name'          => 'Project management',		
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'project-management'	,
                 'description'   => "Legal consulting",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //6
                 'parent_id'     => 5,
                 'name'          => 'Technical projects',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'technical-projects',
                 'description'   => "Legal disputes",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ // 7
                 'parent_id'     => null,
                 'name'          => 'Digital marketing',		
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'digital-marketing'	,
                 'description'   => "Digital marketing",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ // 8
                 'parent_id'     => 7,
                 'name'          => 'Email marketing',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'email-marketing',
                 'description'   => "Email marketing",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ // 9
                 'parent_id'     => 8,
                 'name'          => 'Email automation',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'email-automation',
                 'description'   => "Email automation",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ // 10
                 'parent_id'     => 8,
                 'name'          => 'Email support',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'email-support',
                 'description'   => "Email platform support",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ // 11
                 'parent_id'     => 7,
                 'name'          => 'SEO',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'email-support',
                 'description'   => "Email platform support",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
 
             [ //12
                 'parent_id'     => 11,
                 'name'          => 'Keyword research',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'keyword-research',
                 'description'   => "Keyword research",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //13
                 'parent_id'     => 11,
                 'name'          => 'Off-page seo',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'off-page',
                 'description'   => "Off-page seo",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //14
                 'parent_id'     => 11,
                 'name'          => 'On-page seo',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'on-page',
                 'description'   => "On-page seo",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //15
                 'parent_id'     => null,
                 'name'          => 'Graphics & design',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'graphics-&-design',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //16
                 'parent_id'     => 15,
                 'name'          => 'Illustration',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'illustration',
                 'description'   => "Illustration",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //17
                 'parent_id'     => null,
                 'name'          => 'Health and sports',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'health-and-sports',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //18
                 'parent_id'     => null,
                 'name'          => 'Social media',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'social-media',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //19
                 'parent_id'     => 18,
                 'name'          => 'Social Networking',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'social-networking',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //20
                 'parent_id'     => 18,
                 'name'          => 'Blogging/Community Building',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'blogging/Community-building',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //21
                 'parent_id'     => 19,
                 'name'          => 'Photo Sharing',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'photo-sharing',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //22
                 'parent_id'     => 19,
                 'name'          => 'Video Sharing',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'video-sharing',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //23
                 'parent_id'     => null,
                 'name'          => 'Programming',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'programming',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //24
                 'parent_id'     => 23,
                 'name'          => 'E-commerce development',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'e-commerce-development',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //25
                 'parent_id'     => 24,
                 'name'          => 'Store management',
                 'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                 'slug'          => 'store-management',
                 'description'   => "",
                 'status'        => 'active',
                 'created_at'    => new DateTime(),
                 'updated_at'    => new DateTime(),
             ],
             [ //26
                'parent_id'     => null,
                'name'          => 'Video & animation',
                'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                'slug'          => 'video-&-animation',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //27
                'parent_id'     => 26,
                'name'          => 'Video Editing',
                'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                'slug'          => 'video-editing',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //28
                'parent_id'     => 26,
                'name'          => '3D product animation',
                'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                'slug'          => '3d-product-animation',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //29
                'parent_id'     => null,
                'name'          => 'Writing & Translation',
                'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                'slug'          => 'writing-&-translation',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [ //30
                'parent_id'     => 29,
                'name'          => 'Career Writing',
                'image'         => serialize( uploadDemoImage('posts','gig-categories', 'post-'.rand(1,15).'.webp')),
                'slug'          => 'articles-&-blog-posts',
                'description'   => "",
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
 
         ];
        GigCategory::insert($categories);
    }

    /**
     * Add defualt langueges seeder values.
     */
    public function defaultLanguages(){
        Language::truncate();
        $languages_list = [
            [
                'name' => "Afrikaans",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Albanian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Amharic",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Arabic",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Aragonese",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Armenian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Asturian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Azerbaijani",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Basque",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Belarusian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Bengali",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Bosnian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Breton",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Bulgarian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Catalan",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Central Kurdish",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Chinese",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],           
            [
                'name' => "Corsican",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Croatian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Czech",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Danish",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Dutch",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "English",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Esperanto",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Estonian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Faroese",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Filipino",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Finnish",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "French",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Galician",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Georgian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "German",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Greek",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Guarani",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Gujarati",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Hausa",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Hawaiian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Hebrew",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Hindi",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Hungarian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Icelandic",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Indonesian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Interlingua",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Irish",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Italian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Italian (Italy)",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Italian (Switzerland)",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Japanese",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Kannada",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Kazakh",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Khmer",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Korean",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Kurdish",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Kyrgyz",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Lao",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Latin",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Latvian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Lingala",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Lithuanian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Macedonian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Malay",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Malayalam",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Maltese",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Marathi",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Mongolian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Nepali",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Norwegian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Norwegian Bokmål",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Norwegian Nynorsk",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Occitan",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Oriya",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Oromo",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Pashto",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Persian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Polish",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Portuguese",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Portuguese (Brazil)",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Portuguese (Portugal)",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Punjabi",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Quechua",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Romanian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Romanian (Moldova)",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Romansh",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Russian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Scottish Gaelic",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Serbian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Serbo",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Shona",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Sindhi",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Sinhala",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Slovak",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Slovenian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Somali",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Southern Sotho",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Spanish",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Sundanese",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Swahili",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Swedish",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Tajik",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Tamil",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Tatar",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Telugu",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Thai",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Tigrinya",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Tongan",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Turkish",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Turkmen",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Twi",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Ukrainian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Urdu",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Uyghur",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Uzbek",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Vietnamese",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Walloon",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Welsh",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Western Frisian",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Xhosa",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Yiddish",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Yoruba",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
            [
                'name' => "Zulu",
                'description' => null,
                'status' => 'active',
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            ],
        
        ];
        Language::insert($languages_list);
    }

    /**
     * Add defualt expert levels seeder values.
     */
    public function defaultexpertLevel(){
        ExpertLevel::truncate();
        $expertlevels = [
            [
                'name'          => 'Expert level',
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => 'Junior level',
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => 'Mid level',
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => 'Senior level',
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
        ];

        ExpertLevel::insert($expertlevels);
    }

    /**
     * Add defualt skills seeder values.
     */
    public function defaultSkills(){
        Skill::truncate();
        $skills = [
            [
                'name'          => '3D',
                'slug'          => '3d',
                'description'   => null,
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => 'Analytics',
                'slug'          => 'analytics',
                'description'   => null,
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => 'Backup',
                'slug'          => 'backup',
                'description'   => null,
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => 'UX/UI Designing',
                'slug'          => 'ux/ui-designing',
                'description'   => null,
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => 'Cartoon',
                'slug'          => 'cartoon',
                'description'   => null,
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => 'Consultation',
                'slug'          => 'consultation',
                'description'   => null,
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => 'Resume design',
                'slug'          => 'resume-design',
                'description'   => null,
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => 'WP setup',
                'slug'          => 'wp-setup',
                'description'   => null,
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => 'Development',
                'slug'          => 'development',
                'description'   => null,
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => 'E-commerce',
                'slug'          => 'e-commerce',
                'description'   => null,
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => 'Email marketing',
                'slug'          => 'email-marketing',
                'description'   => null,
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => 'Illustration',
                'slug'          => 'illustration',
                'description'   => null,
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => 'Keyword research',
                'slug'          => 'keyword-research',
                'description'   => null,
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => 'Logo design',
                'slug'          => 'logo-design',
                'description'   => null,
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
        ];

        Skill::insert($skills);
    }


     /**
     * Add defualt delivery time seeder values.
     */
    public function projectDurations(){
        ProjectDuration::truncate();
        $durations = [
            [
                'name'          => __('general.one_day'),
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => __('general.one_week'),
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => __('general.one_month'),
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => __('general.two_months'),
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => __('general.six_months'),
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
        ];
        
        ProjectDuration::insert($durations);

    }

    public function projectLocations(){
        ProjectLocation::truncate();
        $locations = [
            [
                'name'          => __('general.remotely'),
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => __('general.partially_remote'),
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
            [
                'name'          => __('general.onsite'),
                'status'        => 'active',
                'created_at'    => new DateTime(),
                'updated_at'    => new DateTime(),
            ],
        ];
        
        ProjectLocation::insert($locations);
    }
}
