<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('creator_id')->unsigned()->index();
            $table->string('trans_ref_no')->nullable()->index();
            $table->string('invoice_ref_no')->nullable()->index();
            $table->enum('payment_type',['project','package', 'gig'])->index();
            $table->enum('status', ['pending', 'processed', 'completed', 'refunded', 'cancelled'])->default('pending')->index(); 
            $table->string('payment_method',100)->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
};
