import React from "react";
import PropTypes from "prop-types";
import { Link } from "react-router-dom";
import SelectLocation from "../dropdown";

Banner10.propTypes = {};

function Banner10(props) {
  return (
    <section className="tf-slider sl8 parallax">
      <div className="tf-container">
        <div className="row">
          <div className="col-lg-12">
            <div className="content wow fadeInUp">
              <div className="heading text-center">
                <h2 className="text-white">Find the job that fits your life</h2>
                <p className="text-white">
                  Resume-Library is a true performance-based job board. Enjoy
                  custom hiring products and access to up to 10,000 new resume
                  registrations daily, with no subscriptions or user licences.
                </p>
              </div>
              <div className="form-sl">
                <form action="/job-list-sidebar">
                  <div className="row-group-search">
                    <div className="form-group-1">
                      <span className="icon-search search-job"></span>
                      <input
                        type="text"
                        className="input-filter-search"
                        placeholder="Job title, key words or company"
                      />
                    </div>
                    <div className="form-group-2">
                      <span className="icon-map-pin"></span>
                      <SelectLocation />
                    </div>
                    <div className="form-group-4">
                      <button type="submit" className="btn btn-find">
                        Find Jobs
                      </button>
                    </div>
                  </div>
                </form>
              </div>
              <div className="group-icon">
                <div className="sl-icon-box box">
                  <div className="icon">
                    <svg
                      className="svg-color"
                      xmlns="http://www.w3.org/2000/svg"
                      width="36"
                      height="40"
                      viewBox="0 0 36 40"
                      fill="none"
                    >
                      <path
                        d="M34.1147 31.4671C33.6811 28.8678 31.8585 26.7349 29.3585 25.9013L23.8069 24.051V23.2258H22.5166V24.2878C22.1592 24.6826 20.8902 25.8065 18.0005 25.8065C15.1108 25.8065 13.8418 24.6826 13.4844 24.2878V23.2258H12.194V24.051L6.64306 25.9013C4.14306 26.7349 2.32048 28.8678 1.88694 31.4671L0.464355 40H35.536L34.1147 31.4671ZM1.98823 38.7097L2.19532 37.4645L6.48371 38.0007C6.52758 38.2716 6.58307 38.5065 6.64565 38.7097H1.98823ZM6.39274 36.6897L2.40758 36.1916L3.15919 31.68C3.51403 29.5529 5.005 27.8078 7.05081 27.1258L7.09532 27.111L7.65919 32.7484C7.31855 33.3149 6.42242 34.9703 6.39274 36.6897ZM27.9727 38.7097H8.02823C7.88823 38.4297 7.6779 37.8374 7.6779 36.7742C7.6779 35.0639 8.84823 33.2787 8.86048 33.2607L8.98758 33.0684L8.35016 26.6929L12.6366 25.2639C13.2734 25.9026 14.8805 27.0968 18.0005 27.0968C21.1205 27.0968 22.7276 25.9026 23.3644 25.2639L27.6502 26.6929L27.0127 33.0691L27.1405 33.2613C27.1534 33.2787 28.3231 35.0536 28.3231 36.7742C28.3231 37.8374 28.1127 38.4297 27.9727 38.7097ZM28.9056 27.111L28.9502 27.1258C30.996 27.8078 32.4869 29.5529 32.8418 31.68L33.5934 36.1916L29.6082 36.6897C29.5792 34.971 28.6831 33.3149 28.3418 32.7484L28.9056 27.111ZM29.356 38.7097C29.4185 38.5065 29.4734 38.2716 29.5179 38.0007L33.8063 37.4645L34.0127 38.7097H29.356Z"
                        fill="white"
                      />
                      <path
                        d="M9.89852 17.3832C10.2276 18.5155 10.8353 19.5535 11.6921 20.4103L14.2076 22.9265C14.8166 23.5355 15.6269 23.871 16.4888 23.871H19.5121C20.374 23.871 21.1843 23.5355 21.7934 22.9265L24.3088 20.4103C25.1656 19.5535 25.7727 18.5148 26.1024 17.3832C27.7101 17.2013 28.9682 15.849 28.9682 14.1935C28.9682 13.1761 28.4811 12.2213 27.6779 11.6161V6.00774C27.6779 2.69548 24.9824 0 21.6701 0H14.3308C11.0185 0 8.32304 2.69548 8.32304 6.00774V11.6161C7.51981 12.2213 7.03271 13.1761 7.03271 14.1935C7.03271 15.849 8.29078 17.2013 9.89852 17.3832ZM25.0972 15.3923C25.0972 16.9432 24.4927 18.4013 23.3966 19.4981L20.8811 22.0142C20.5153 22.3794 20.0295 22.5806 19.5121 22.5806H16.4888C15.9714 22.5806 15.485 22.3794 15.1198 22.0142L12.6043 19.4981C11.5082 18.4013 10.9037 16.9432 10.9037 15.3923V13.3703C11.2979 13.4742 11.725 13.5484 12.194 13.5484C13.1663 13.5484 13.8424 13.271 14.5579 12.9774C15.4192 12.6232 16.3101 12.2581 18.0005 12.2581C19.6908 12.2581 20.5817 12.6232 21.443 12.9774C22.1585 13.271 22.8346 13.5484 23.8069 13.5484C24.2759 13.5484 24.703 13.4742 25.0972 13.3703V15.3923ZM23.8069 12.2581C23.0895 12.2581 22.5792 12.0484 21.9334 11.7832C21.0476 11.42 19.9456 10.9677 18.0005 10.9677C16.0553 10.9677 14.9534 11.42 14.0676 11.7832C13.4217 12.0484 12.9114 12.2581 12.194 12.2581C11.1392 12.2581 10.2979 11.8019 9.82949 11.4768C10.5476 10.5368 12.7598 8.3871 18.0005 8.3871C23.2482 8.3871 25.4598 10.5432 26.1734 11.4787C25.7095 11.8039 24.8727 12.2581 23.8069 12.2581ZM27.6779 14.1935C27.6779 15.0445 27.1217 15.7613 26.3572 16.0194C26.3753 15.8123 26.3876 15.6032 26.3876 15.3923V12.8587C26.5469 12.771 26.6888 12.6832 26.8159 12.5987C27.3456 12.9568 27.6779 13.5503 27.6779 14.1935ZM9.61336 6.00774C9.61336 3.40645 11.7295 1.29032 14.3308 1.29032H21.6695C24.2714 1.29032 26.3876 3.40645 26.3876 6.00774V9.82387C25.0682 8.6071 22.5256 7.09677 18.0005 7.09677C13.4753 7.09677 10.9327 8.6071 9.61336 9.82387V6.00774ZM9.18497 12.5981C9.31207 12.6832 9.454 12.7703 9.61336 12.8581V15.3916C9.61336 15.6026 9.62562 15.8116 9.64368 16.0194C8.87917 15.7613 8.32304 15.0445 8.32304 14.1935C8.32304 13.5503 8.65594 12.9568 9.18497 12.5981Z"
                        fill="white"
                      />
                      <path
                        d="M24.0225 31.7885C23.9316 32.7917 23.1032 33.5485 22.0954 33.5485H13.9057C12.898 33.5485 12.069 32.7917 11.978 31.7885L11.5464 27.0388L10.2612 27.1556L10.6928 31.9059C10.8451 33.5775 12.2264 34.8388 13.9057 34.8388H22.0948C23.7748 34.8388 25.1554 33.5775 25.3077 31.9053L25.7393 27.1556L24.4541 27.0388L24.0225 31.7885Z"
                        fill="white"
                      />
                    </svg>
                  </div>
                  <div className="icon-content">
                    <h5>
                      <Link to="jobs-single.html">Delivery Driver</Link>
                    </h5>
                  </div>
                </div>
                <div className="sl-icon-box box">
                  <div className="icon">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="36"
                      height="40"
                      viewBox="0 0 36 40"
                      fill="none"
                    >
                      <path
                        d="M28.5173 28.4112L24.8041 27.1737L23.471 24.5075C24.672 23.2852 25.5058 21.6678 25.787 19.9809L25.9532 18.9844H27.375C28.6673 18.9844 29.7188 17.933 29.7188 16.6406V11.7188C29.7188 5.25703 24.4617 0 18 0C11.5217 0 6.28125 5.24195 6.28125 11.7188V16.6406C6.28125 17.6591 6.93445 18.5275 7.84375 18.85V19.7656C7.84375 21.058 8.89516 22.1094 10.1875 22.1094H10.8736C11.2123 22.8451 11.6506 23.5265 12.1841 24.1386C12.2947 24.2658 12.4101 24.3891 12.5283 24.509L11.1959 27.1737L7.48258 28.4113C3.165 29.8509 0.03125 34.3962 0.03125 39.2188C0.03125 39.6502 0.381016 40 0.8125 40H35.1875C35.6189 40 35.9688 39.6502 35.9688 39.2188C35.9688 34.3962 32.8351 29.8509 28.5173 28.4112ZM28.1562 16.6406C28.1562 17.0714 27.8058 17.4219 27.375 17.4219H26.1827C26.3813 15.8836 26.5136 14.2466 26.5668 12.6344C26.5684 12.5889 26.5696 12.5447 26.571 12.5H28.1562V16.6406ZM8.625 17.4219C8.19422 17.4219 7.84375 17.0714 7.84375 16.6406V12.5H9.42953C9.43211 12.5815 9.43484 12.6634 9.43789 12.7458C9.43797 12.7486 9.43812 12.7513 9.4382 12.7541C9.4382 12.7544 9.4382 12.7546 9.4382 12.7548C9.49289 14.323 9.62352 15.9174 9.81758 17.4218H8.625V17.4219ZM10.1875 20.5469C9.75672 20.5469 9.40625 20.1964 9.40625 19.7656V18.9844H10.0467L10.213 19.9812C10.2447 20.1706 10.2837 20.3594 10.3287 20.5469H10.1875ZM9.40758 10.9375H7.87344C8.26914 5.70148 12.6388 1.5625 18 1.5625C23.3373 1.5625 27.7262 5.70094 28.1265 10.9375H26.5925C26.5363 6.62289 23.0227 3.125 18.6993 3.125H17.3009C12.9775 3.125 9.46375 6.62289 9.40758 10.9375ZM17.3008 4.6875H18.6992C22.1999 4.6875 25.0333 7.55086 25.0312 11.0477C25.0312 11.2935 25.0293 11.5076 25.0252 11.7023C25.0252 11.7048 25.0251 11.7074 25.0251 11.71L24.0479 11.5704C21.3932 11.1913 18.8866 9.93805 16.9899 8.04133C16.8434 7.89484 16.6447 7.8125 16.4375 7.8125C14.3394 7.8125 12.3309 8.76844 11.0033 10.3834C11.3305 7.20227 14.0198 4.6875 17.3008 4.6875ZM11.9484 20.5469C11.5573 19.2459 11.1098 15.4177 11.0109 12.9646L12.0624 11.5626C13.0281 10.2754 14.5305 9.47563 16.1287 9.38383C18.2316 11.3851 20.9521 12.7066 23.827 13.1171L24.9771 13.2815C24.9002 14.9131 24.7431 16.5505 24.518 18.0563C24.518 18.0568 24.5179 18.0573 24.5178 18.0579C24.4463 18.542 24.3898 18.8536 24.2458 19.7238C23.832 22.2055 21.9803 24.4496 19.5359 25.0608C18.5298 25.312 17.47 25.3119 16.4645 25.0608C14.9382 24.6792 13.5387 23.6231 12.6355 22.1094H14.2281C14.5506 23.0187 15.419 23.6719 16.4375 23.6719H18C19.2949 23.6719 20.3438 22.6231 20.3438 21.3281C20.3438 20.0358 19.2923 18.9844 18 18.9844H16.4375C15.3963 18.9844 14.5408 19.6569 14.2268 20.5469H11.9484ZM16.3718 26.6419C16.9077 26.7548 17.454 26.8125 18 26.8125C18.4274 26.8125 18.8549 26.7767 19.2776 26.7073L17.8971 28.1673L16.3718 26.6419ZM16.823 29.303L14.3451 31.9235C13.6629 30.6177 13.0767 29.2588 12.5959 27.8675L13.5265 26.0064L16.823 29.303ZM22.3411 25.7417L23.4039 27.8674C22.9223 29.261 22.336 30.6205 21.6545 31.9247L19.0023 29.2725L22.3411 25.7417ZM15.6562 21.3281C15.6562 20.8968 16.0061 20.5469 16.4375 20.5469H18C18.4308 20.5469 18.7812 20.8973 18.7812 21.3281C18.7812 21.7595 18.4313 22.1094 18 22.1094H16.4375C16.0067 22.1094 15.6562 21.7589 15.6562 21.3281ZM1.625 38.4375C1.93461 34.5673 4.51031 31.0495 7.97672 29.8935L11.2653 28.7976C11.8678 30.4636 12.6142 32.0829 13.489 33.621C13.4905 33.6237 13.4919 33.6263 13.4934 33.6289L13.4934 33.6291C14.1326 34.7532 14.852 35.8517 15.6319 36.8946L16.593 38.4375H1.625ZM18 37.7411L16.9405 36.0401C16.9286 36.021 16.9159 36.0025 16.9025 35.9845C16.2698 35.1406 15.6797 34.258 15.1422 33.3547L17.9284 30.4083L20.8641 33.3441C20.323 34.254 19.7309 35.1402 19.0977 35.9844C19.0594 36.0354 19.1137 35.955 18 37.7411ZM19.407 38.4375L20.368 36.8947C21.1514 35.8478 21.8759 34.7405 22.5215 33.6031C22.5254 33.5962 22.5291 33.5892 22.533 33.5823C22.5334 33.5815 22.5339 33.5807 22.5344 33.5798C23.398 32.0564 24.1366 30.4512 24.7347 28.7976L28.0232 29.8935C31.4897 31.0495 34.0654 34.5673 34.375 38.4375H19.407Z"
                        fill="white"
                      />
                    </svg>
                  </div>
                  <div className="icon-content">
                    <h5>
                      <Link to="jobs-single.html">Customer Service</Link>
                    </h5>
                  </div>
                </div>
                <div className="sl-icon-box box">
                  <div className="icon">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="41"
                      height="40"
                      viewBox="0 0 41 40"
                      fill="none"
                    >
                      <g clipPath="url(#clip0_5698_114181)">
                        <path
                          d="M11.0888 26.7964H5.91455C5.74879 26.7964 5.58982 26.8622 5.47261 26.9794C5.3554 27.0966 5.28955 27.2556 5.28955 27.4214V37.5346C5.28955 37.7004 5.3554 37.8594 5.47261 37.9766C5.58982 38.0938 5.74879 38.1596 5.91455 38.1596H11.0888C11.2545 38.1596 11.4135 38.0938 11.5307 37.9766C11.6479 37.8594 11.7138 37.7004 11.7138 37.5346V27.4214C11.7138 27.2556 11.6479 27.0966 11.5307 26.9794C11.4135 26.8622 11.2545 26.7964 11.0888 26.7964ZM10.4638 36.9096H6.53955V28.0464H10.4638V36.9096ZM30.3267 22.2462H25.1524C24.9867 22.2462 24.8277 22.3121 24.7105 22.4293C24.5933 22.5465 24.5274 22.7054 24.5274 22.8712V37.5346C24.5274 37.7004 24.5933 37.8594 24.7105 37.9766C24.8277 38.0938 24.9867 38.1596 25.1524 38.1596H30.3267C30.4925 38.1596 30.6515 38.0938 30.7687 37.9766C30.8859 37.8594 30.9517 37.7004 30.9517 37.5346V22.8712C30.9517 22.7054 30.8859 22.5465 30.7687 22.4293C30.6515 22.3121 30.4925 22.2462 30.3267 22.2462ZM29.7017 36.9096H25.7774V23.4962H29.7017V36.9096ZM20.7078 17.696H15.5334C15.3676 17.696 15.2086 17.7618 15.0914 17.879C14.9742 17.9962 14.9084 18.1552 14.9084 18.321V37.5346C14.9084 37.7004 14.9742 37.8594 15.0914 37.9766C15.2086 38.0938 15.3676 38.1596 15.5334 38.1596H20.7078C20.8735 38.1596 21.0325 38.0938 21.1497 37.9766C21.2669 37.8594 21.3328 37.7004 21.3328 37.5346V18.321C21.3328 18.1552 21.2669 17.9962 21.1497 17.879C21.0325 17.7618 20.8735 17.696 20.7078 17.696ZM20.0828 36.9096H16.1584V18.946H20.0828V36.9096ZM39.9458 13.1457H34.7714C34.6057 13.1457 34.4467 13.2116 34.3295 13.3288C34.2123 13.446 34.1464 13.605 34.1464 13.7707V37.5346C34.1464 37.7004 34.2123 37.8594 34.3295 37.9766C34.4467 38.0938 34.6057 38.1596 34.7714 38.1596H39.9458C40.1116 38.1596 40.2705 38.0938 40.3877 37.9766C40.505 37.8594 40.5708 37.7004 40.5708 37.5346V13.7707C40.5708 13.605 40.505 13.446 40.3877 13.3288C40.2705 13.2116 40.1116 13.1457 39.9458 13.1457ZM39.3208 36.9096H35.3964V14.3957H39.3208V36.9096ZM8.03869 21.9031L17.6577 11.3003C17.7592 11.1884 17.8979 11.1171 18.048 11.0995C18.1981 11.082 18.3495 11.1194 18.4741 11.2049L27.6688 17.5096L36.0735 8.17886H33.0202C32.8544 8.17886 32.6954 8.11301 32.5782 7.9958C32.461 7.87859 32.3952 7.71962 32.3952 7.55386C32.3952 7.3881 32.461 7.22913 32.5782 7.11192C32.6954 6.99471 32.8544 6.92886 33.0202 6.92886H37.4981C37.6638 6.92886 37.8228 6.99471 37.94 7.11192C38.0572 7.22913 38.1231 7.3881 38.1231 7.55386V12.0317C38.1231 12.1975 38.0572 12.3565 37.94 12.4737C37.8228 12.5909 37.6638 12.6567 37.4981 12.6567C37.3323 12.6567 37.1733 12.5909 37.0561 12.4737C36.9389 12.3565 36.8731 12.1975 36.8731 12.0317V9.15909L28.2312 18.7532C28.1298 18.8658 27.991 18.9377 27.8405 18.9556C27.6901 18.9735 27.5383 18.9361 27.4133 18.8504L18.217 12.5442L8.96439 22.7428C8.8536 22.8632 8.69996 22.9354 8.53651 22.9438C8.37306 22.9522 8.21283 22.8962 8.09025 22.7877C7.96767 22.6793 7.89252 22.5271 7.88095 22.3638C7.86939 22.2006 7.92232 22.0393 8.02838 21.9146C8.03174 21.9109 8.03518 21.9067 8.03869 21.9031ZM8.83643 12.0792V11.9812C9.13388 11.8802 9.39468 11.6932 9.5858 11.4439C9.77693 11.1946 9.88979 10.8942 9.91009 10.5807C9.93039 10.2673 9.85722 9.9548 9.69985 9.68293C9.54248 9.41106 9.30798 9.19199 9.02603 9.05347C9.12128 9.09753 9.22609 9.1169 9.33079 9.10979C9.4355 9.10268 9.53673 9.06932 9.62514 9.01279C9.71356 8.95626 9.78632 8.87837 9.8367 8.78631C9.88709 8.69425 9.91349 8.59099 9.91346 8.48604C9.90848 8.15528 9.80271 7.8339 9.61026 7.56484C9.41781 7.29578 9.14785 7.09184 8.83643 6.98026V6.88292C8.83643 6.71716 8.77058 6.55819 8.65337 6.44098C8.53616 6.32377 8.37719 6.25792 8.21143 6.25792C8.04567 6.25792 7.88669 6.32377 7.76948 6.44098C7.65227 6.55819 7.58643 6.71716 7.58643 6.88292V6.98073C7.28889 7.08174 7.02803 7.26878 6.83689 7.51816C6.64575 7.76754 6.53292 8.06804 6.5127 8.3816C6.49247 8.69516 6.56577 9.00766 6.7233 9.27953C6.88083 9.5514 7.1155 9.77039 7.3976 9.90878C7.30234 9.86455 7.19748 9.84504 7.09269 9.85205C6.9879 9.85906 6.88657 9.89236 6.79805 9.94888C6.70953 10.0054 6.63668 10.0833 6.58623 10.1754C6.53578 10.2675 6.50936 10.3709 6.50939 10.4759C6.51448 10.8066 6.62031 11.1278 6.81275 11.3968C7.00519 11.6658 7.27509 11.8696 7.58643 11.9812V12.079C7.58643 12.2448 7.65227 12.4037 7.76948 12.521C7.88669 12.6382 8.04567 12.704 8.21143 12.704C8.37719 12.704 8.53616 12.6382 8.65337 12.521C8.77058 12.4037 8.83643 12.2448 8.83643 12.079V12.0792ZM8.98814 9.03456C8.74627 8.91653 8.48056 8.85551 8.21143 8.8562C7.96643 8.8562 7.75939 8.6869 7.75939 8.48659C7.75939 8.28628 7.96643 8.11698 8.21143 8.11698C8.45643 8.11698 8.66346 8.28628 8.66346 8.48659C8.6634 8.59867 8.69348 8.7087 8.75055 8.80516C8.80761 8.90162 8.88957 8.98096 8.98783 9.03487L8.98814 9.03456ZM7.43361 9.92651C7.67572 10.0451 7.94182 10.1066 8.21143 10.1062C8.4565 10.1062 8.66346 10.2754 8.66346 10.4758C8.66346 10.6762 8.4565 10.8453 8.21143 10.8453C7.96635 10.8453 7.75939 10.6761 7.75939 10.4758C7.7595 10.3634 7.72929 10.2531 7.67196 10.1564C7.61463 10.0597 7.53229 9.98032 7.43361 9.92651ZM12.722 9.4812C12.722 8.58903 12.4575 7.71688 11.9619 6.97504C11.4663 6.2332 10.7618 5.65499 9.93756 5.31354C9.11331 4.97209 8.20632 4.88273 7.33129 5.05676C6.45625 5.23079 5.65248 5.6604 5.02161 6.29126C4.39075 6.92211 3.96113 7.72588 3.78708 8.60091C3.61303 9.47594 3.70237 10.3829 4.04381 11.2072C4.38525 12.0314 4.96344 12.7359 5.70527 13.2316C6.44711 13.7272 7.31925 13.9917 8.21143 13.9917C9.40727 13.9903 10.5538 13.5147 11.3994 12.6691C12.245 11.8235 12.7206 10.677 12.722 9.4812ZM4.95041 9.4812C4.95035 8.83628 5.14153 8.20582 5.49978 7.66955C5.85803 7.13328 6.36726 6.71529 6.96307 6.46843C7.55888 6.22158 8.21452 6.15694 8.84706 6.28271C9.4796 6.40847 10.0606 6.71898 10.5167 7.17497C10.9728 7.63097 11.2834 8.21196 11.4093 8.84448C11.5351 9.47701 11.4706 10.1326 11.2239 10.7285C10.9771 11.3244 10.5592 11.8337 10.023 12.192C9.48678 12.5503 8.85635 12.7416 8.21143 12.7417C7.34663 12.7417 6.51722 12.3983 5.90566 11.7868C5.29411 11.1753 4.95049 10.346 4.95041 9.4812ZM6.23229 15.3285L6.36119 16.5614C6.37726 16.715 6.44967 16.8573 6.56445 16.9607C6.67924 17.0641 6.82826 17.1213 6.98275 17.1214H9.43955C9.59405 17.1213 9.74307 17.0641 9.85785 16.9607C9.97263 16.8573 10.045 16.715 10.0611 16.5614L10.19 15.3285C10.4488 15.241 10.7015 15.1361 10.9463 15.0148L11.9096 15.796C12.0296 15.8933 12.1814 15.9427 12.3357 15.9347C12.49 15.9266 12.6358 15.8617 12.7451 15.7525L14.4823 14.0153C14.5915 13.906 14.6565 13.7602 14.6645 13.6059C14.6726 13.4516 14.6232 13.2997 14.5259 13.1797L13.7446 12.2165C13.8659 11.9717 13.9707 11.719 14.0583 11.4602L15.2912 11.3313C15.4449 11.3152 15.5871 11.2428 15.6905 11.128C15.7939 11.0132 15.8512 10.8642 15.8512 10.7097V8.25245C15.8512 8.09795 15.7939 7.94893 15.6905 7.83415C15.5871 7.71937 15.4449 7.64696 15.2912 7.63089L14.0584 7.50198C13.9708 7.2432 13.866 6.99056 13.7447 6.74573L14.526 5.78245C14.6232 5.66243 14.6726 5.51063 14.6646 5.35635C14.6565 5.20206 14.5916 5.05623 14.4824 4.94698L12.7451 3.20979C12.6358 3.10053 12.49 3.03561 12.3357 3.02756C12.1814 3.01951 12.0296 3.0689 11.9096 3.1662L10.9463 3.94745C10.7015 3.82622 10.4488 3.72143 10.1899 3.63378L10.0611 2.40097C10.0451 2.24724 9.97276 2.10488 9.85797 2.00138C9.74318 1.89789 9.59411 1.8406 9.43955 1.84058H6.98275C6.82824 1.84057 6.6792 1.8978 6.56441 2.00121C6.44961 2.10463 6.37718 2.2469 6.36111 2.40058L6.23221 3.63347C5.97341 3.72103 5.72076 3.82583 5.47596 3.94714L4.51275 3.16589C4.39274 3.06858 4.24093 3.01917 4.08662 3.02721C3.93232 3.03525 3.78647 3.10015 3.67721 3.2094L1.94002 4.94698C1.83078 5.05623 1.76587 5.20206 1.75782 5.35635C1.74977 5.51063 1.79915 5.66243 1.89643 5.78245L2.67768 6.74573C2.55643 6.99059 2.45164 7.24326 2.364 7.50206L1.1308 7.63089C0.977127 7.64696 0.834853 7.71938 0.731436 7.83418C0.62802 7.94898 0.570793 8.09802 0.570801 8.25253L0.570801 10.7092C0.570793 10.8638 0.62802 11.0128 0.731436 11.1276C0.834853 11.2424 0.977127 11.3148 1.1308 11.3309L2.36369 11.4598C2.45126 11.7186 2.55605 11.9712 2.67736 12.216L1.89611 13.1792C1.7987 13.2993 1.74925 13.4512 1.7573 13.6056C1.76535 13.76 1.83034 13.9059 1.93971 14.0152L3.67689 15.7524C3.78617 15.8617 3.93209 15.9267 4.08649 15.9348C4.24088 15.9428 4.39278 15.8934 4.51283 15.796L5.47604 15.0147C5.72088 15.1359 5.97352 15.2406 6.23229 15.3282V15.3285ZM5.01236 13.7817L4.16291 14.4703L3.22205 13.5291L3.91064 12.6798C3.99081 12.5809 4.03888 12.46 4.04843 12.333C4.05798 12.2061 4.02855 12.0793 3.96408 11.9696C3.73517 11.5803 3.56133 11.1612 3.44752 10.7242C3.41548 10.601 3.34663 10.4906 3.25016 10.4077C3.1537 10.3247 3.03421 10.2732 2.90768 10.26L1.8208 10.1462V8.81558L2.90768 8.70198C3.03422 8.68874 3.15371 8.63719 3.25018 8.55423C3.34665 8.47126 3.41549 8.36083 3.44752 8.23769C3.56139 7.8007 3.73523 7.38159 3.96408 6.9923C4.02854 6.88256 4.05795 6.75577 4.0484 6.62886C4.03886 6.50196 3.99079 6.38099 3.91064 6.28214L3.22205 5.43269L4.16291 4.49175L5.01236 5.18042C5.11123 5.26057 5.23222 5.30863 5.35914 5.31817C5.48606 5.3277 5.61286 5.29826 5.7226 5.23378C6.11193 5.00494 6.53106 4.83111 6.96807 4.71722C7.09118 4.68516 7.20158 4.61631 7.28452 4.51984C7.36745 4.42338 7.41898 4.3039 7.43221 4.17737L7.5458 3.09058H8.87643L8.9901 4.17737C9.00331 4.30391 9.05483 4.42341 9.13777 4.51989C9.22071 4.61637 9.33111 4.68524 9.45424 4.71729C9.89127 4.83114 10.3104 5.00495 10.6998 5.23378C10.8095 5.29824 10.9363 5.32768 11.0632 5.31814C11.1901 5.3086 11.3111 5.26056 11.4099 5.18042L12.2593 4.49175L13.2003 5.43269L12.5116 6.28206C12.4314 6.38093 12.3834 6.50191 12.3738 6.62883C12.3643 6.75575 12.3937 6.88256 12.4582 6.9923C12.6871 7.38163 12.861 7.80079 12.9748 8.23784C13.0068 8.36095 13.0757 8.47135 13.1722 8.55429C13.2686 8.63723 13.3881 8.68875 13.5146 8.70198L14.6015 8.81558V10.1462L13.5146 10.2598C13.3881 10.273 13.2686 10.3246 13.1721 10.4075C13.0757 10.4905 13.0068 10.601 12.9748 10.7241C12.8609 11.1611 12.6871 11.5802 12.4582 11.9696C12.3938 12.0793 12.3644 12.2061 12.3739 12.3329C12.3834 12.4598 12.4315 12.5808 12.5116 12.6796L13.2003 13.5291L12.2593 14.47L11.4099 13.7814C11.3111 13.7012 11.1901 13.6531 11.0632 13.6436C10.9362 13.6341 10.8094 13.6635 10.6997 13.728C10.3104 13.9569 9.89133 14.1307 9.45432 14.2445C9.33119 14.2765 9.22077 14.3454 9.13782 14.4418C9.05487 14.5383 9.00333 14.6578 8.9901 14.7843L8.8765 15.8712H7.5458L7.43221 14.7843C7.41897 14.6578 7.36742 14.5383 7.28445 14.4418C7.20149 14.3454 7.09105 14.2765 6.96791 14.2445C6.53091 14.1306 6.11178 13.9568 5.72244 13.728C5.61272 13.6636 5.48595 13.6341 5.35906 13.6437C5.23217 13.6532 5.11122 13.7012 5.01236 13.7814V13.7817Z"
                          fill="white"
                        />
                      </g>
                      <defs>
                        <clipPath id="clip0_5698_114181">
                          <rect
                            width="40"
                            height="40"
                            fill="white"
                            transform="translate(0.570801)"
                          />
                        </clipPath>
                      </defs>
                    </svg>
                  </div>
                  <div className="icon-content">
                    <h5>
                      <Link to="jobs-single.html">Data Science</Link>
                    </h5>
                  </div>
                </div>
                <div className="sl-icon-box box">
                  <div className="icon">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="41"
                      height="40"
                      viewBox="0 0 41 40"
                      fill="none"
                    >
                      <g clipPath="url(#clip0_5698_114178)">
                        <path
                          d="M40.4282 17.7296V22.2702C40.4282 23.4202 39.4926 24.3557 38.3428 24.3557H35.2747C34.9637 25.4168 34.538 26.443 34.0049 27.4166L36.1757 29.5873C36.9888 30.4005 36.9888 31.7236 36.1757 32.5367L32.965 35.7475C32.9462 35.7663 32.9271 35.7847 32.9078 35.8026C32.7874 35.9141 32.6351 35.9692 32.483 35.9692C32.3151 35.9692 32.1476 35.902 32.0245 35.7691C31.7899 35.5159 31.8048 35.1205 32.058 34.8858C32.0658 34.8785 32.0735 34.8711 32.0811 34.8635L35.2918 31.6527C35.6176 31.327 35.6176 30.797 35.2918 30.4713L32.7844 27.9638C32.583 27.7623 32.5432 27.4502 32.6879 27.2046C33.358 26.0669 33.8647 24.8454 34.1938 23.574C34.2652 23.2983 34.514 23.1056 34.7988 23.1056H38.3427C38.8033 23.1056 39.1781 22.7308 39.1781 22.2702V17.7295C39.1781 17.2689 38.8033 16.8941 38.3427 16.8941H34.7988C34.514 16.8941 34.2653 16.7016 34.1938 16.4259C33.8642 15.1533 33.3574 13.9317 32.6879 12.7951C32.5432 12.5496 32.583 12.2373 32.7844 12.0359L35.2919 9.52851C35.6176 9.20273 35.6176 8.67266 35.2918 8.34695L32.0811 5.13625C31.9244 4.97953 31.7147 4.89328 31.4903 4.89328C31.266 4.89328 31.0561 4.97953 30.8995 5.13625L28.3921 7.64367C28.1906 7.845 27.8787 7.88492 27.6329 7.74016C26.4952 7.07008 25.2737 6.56336 24.0023 6.2343C23.7266 6.16289 23.5339 5.91406 23.5339 5.62922V2.08547C23.5339 1.62484 23.1592 1.25 22.6985 1.25H18.1578C17.6972 1.25 17.3224 1.62484 17.3224 2.08547V5.6293C17.3224 5.91414 17.1299 6.16289 16.8542 6.2343C15.5816 6.56398 14.36 7.0707 13.2235 7.74023C12.9778 7.88484 12.6656 7.84508 12.4642 7.64375L9.95682 5.13633C9.80018 4.97961 9.59033 4.89336 9.36596 4.89336C9.14158 4.89336 8.93189 4.97961 8.77525 5.13625L5.56447 8.34703C5.23869 8.67273 5.23869 9.20281 5.56447 9.52867L8.07189 12.0359C8.2733 12.2374 8.31307 12.5496 8.16846 12.7951C7.4983 13.9329 6.99158 15.1545 6.66252 16.4259C6.59111 16.7016 6.34229 16.8942 6.05744 16.8942H2.51369C2.05307 16.8942 1.67822 17.269 1.67822 17.7296V22.2702C1.67822 22.7309 2.05307 23.1057 2.51369 23.1057H6.05752C6.34236 23.1057 6.59111 23.2983 6.66252 23.574C6.99221 24.8466 7.49893 26.0681 8.16846 27.2047C8.31314 27.4502 8.27338 27.7624 8.07197 27.9639L5.56455 30.4713C5.23877 30.797 5.23877 31.3271 5.56455 31.6528L8.77533 34.8636C8.78369 34.872 8.79096 34.8791 8.79838 34.8859C9.0515 35.1205 9.0665 35.5159 8.83189 35.7691C8.59721 36.0223 8.20189 36.0373 7.94861 35.8027C7.92885 35.7843 7.90924 35.7655 7.89018 35.7463L4.68064 32.5368C3.8676 31.7237 3.8676 30.4005 4.68064 29.5874L6.85143 27.4167C6.31869 26.4437 5.89307 25.4177 5.58174 24.3558H2.51369C1.36385 24.3558 0.428223 23.4202 0.428223 22.2703V17.7297C0.428223 16.5798 1.36385 15.6443 2.51369 15.6443H5.58174C5.89268 14.5832 6.31846 13.557 6.8515 12.5834L4.68072 10.4127C3.86768 9.59945 3.86768 8.27633 4.68072 7.4632L7.8915 4.2525C8.28424 3.85984 8.80791 3.64344 9.36611 3.64344C9.92432 3.64344 10.4481 3.85977 10.8408 4.2525L13.0116 6.42328C13.9846 5.89055 15.0106 5.46492 16.0725 5.15359V2.08547C16.0724 0.935547 17.008 0 18.1578 0H22.6985C23.8485 0 24.7839 0.935547 24.7839 2.08547V5.15352C25.845 5.46445 26.8712 5.89023 27.8449 6.42328L30.0156 4.2525C30.4084 3.85977 30.9321 3.64344 31.4903 3.64344C32.0485 3.64344 32.5722 3.85984 32.9649 4.25258L36.1757 7.4632C36.9888 8.27633 36.9888 9.59945 36.1757 10.4126L34.0049 12.5833C34.5377 13.5563 34.9633 14.5823 35.2746 15.6443H38.3427C39.4926 15.6442 40.4282 16.5798 40.4282 17.7296ZM28.0385 26.5176C28.1513 26.6027 28.2835 26.6437 28.4146 26.6437C28.6039 26.6437 28.791 26.558 28.9139 26.3952C30.3135 24.5408 31.0533 22.3293 31.0533 20C31.0533 14.1413 26.2869 9.37492 20.4282 9.37492C14.5696 9.37492 9.80314 14.1413 9.80314 20C9.80314 22.3293 10.543 24.5408 11.9425 26.3952C12.1505 26.6706 12.5425 26.7254 12.8179 26.5175C13.0934 26.3095 13.1482 25.9176 12.9403 25.6421C11.7056 24.0063 11.0531 22.0553 11.0531 19.9999C11.0531 14.8305 15.2588 10.6248 20.4282 10.6248C25.5977 10.6248 29.8033 14.8305 29.8033 20C29.8033 22.0554 29.1507 24.0064 27.9162 25.6422C27.7083 25.9177 27.7631 26.3096 28.0385 26.5176ZM29.297 28.5279C30.4346 29.7656 31.0611 31.3678 31.0611 33.0393V39.375C31.0611 39.7202 30.7813 40 30.4361 40H10.4203C10.0752 40 9.79533 39.7202 9.79533 39.375V33.0393C9.79533 31.3677 10.4219 29.7656 11.5595 28.5279C12.6898 27.2982 14.2201 26.5384 15.8685 26.3887C16.148 26.3626 16.4115 26.5283 16.5103 26.7919L17.6474 29.8279L18.4936 32.0495L18.9366 29.7027L17.6252 27.2841C17.5202 27.0905 17.5249 26.8559 17.6376 26.6665C17.7503 26.4772 17.9543 26.3613 18.1746 26.3613H22.6817C22.9021 26.3613 23.1061 26.4772 23.2188 26.6665C23.3314 26.8559 23.3362 27.0905 23.2312 27.2841L21.9198 29.7027L22.3628 32.0495L23.2102 29.8245L24.346 26.7918C24.4448 26.5281 24.7073 26.3634 24.9878 26.3886C26.6363 26.5384 28.1667 27.2982 29.297 28.5279ZM19.7081 38.75L16.4781 30.2696L15.5145 27.6969C12.9736 28.157 11.0453 30.418 11.0453 33.0393V38.75H19.7081ZM20.4282 37.1288L21.5123 34.2827L20.6503 29.7163C20.6237 29.575 20.6465 29.4288 20.715 29.3024L21.632 27.6113H19.2245L20.1414 29.3024C20.2099 29.4288 20.2328 29.575 20.2061 29.7163L19.3442 34.2827L20.4282 37.1288ZM29.8111 33.0393C29.8111 30.418 27.8828 28.157 25.342 27.6969L24.3797 30.2663L21.1484 38.75H29.8111V33.0393ZM20.4282 14.3219C23.6042 14.3219 26.1881 16.9057 26.1881 20.0818C26.1881 23.2579 23.6042 25.8416 20.4282 25.8416C17.2522 25.8416 14.6683 23.2578 14.6683 20.0817C14.6683 16.9056 17.2522 14.3219 20.4282 14.3219ZM20.4282 15.5719C17.9415 15.5719 15.9183 17.595 15.9183 20.0818C15.9183 22.5686 17.9415 24.5916 20.4282 24.5916C22.9149 24.5916 24.9381 22.5685 24.9381 20.0817C24.9381 17.5949 22.9149 15.5719 20.4282 15.5719Z"
                          fill="white"
                        />
                      </g>
                      <defs>
                        <clipPath id="clip0_5698_114178">
                          <rect
                            width="40"
                            height="40"
                            fill="white"
                            transform="translate(0.428223)"
                          />
                        </clipPath>
                      </defs>
                    </svg>
                  </div>
                  <div className="icon-content">
                    <h5>
                      <Link to="jobs-single.html">Project Manager</Link>
                    </h5>
                  </div>
                </div>
                <div className="sl-icon-box box">
                  <div className="icon">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="40"
                      height="40"
                      viewBox="0 0 40 40"
                      fill="none"
                    >
                      <g clipPath="url(#clip0_5698_114373)">
                        <path
                          d="M12.8173 17.7701H15.8692C16.6641 17.7701 17.3108 17.1234 17.3108 16.3285V15.267C17.3108 14.4721 16.6641 13.8255 15.8692 13.8255H12.8173C12.0224 13.8255 11.3758 14.4721 11.3758 15.267V16.3285C11.3757 17.1234 12.0224 17.7701 12.8173 17.7701ZM12.6257 15.267C12.6257 15.1631 12.7134 15.0755 12.8172 15.0755H15.8691C15.973 15.0755 16.0607 15.1631 16.0607 15.267V16.3285C16.0607 16.4323 15.973 16.5201 15.8691 16.5201H12.8172C12.7134 16.5201 12.6257 16.4323 12.6257 16.3285V15.267ZM9.1632 25.2777H6.11125C5.31641 25.2777 4.66977 25.9244 4.66977 26.7193V27.7809C4.66977 28.5758 5.31641 29.2224 6.11125 29.2224H9.1632C9.95805 29.2224 10.6047 28.5758 10.6047 27.7809V26.7193C10.6047 25.9244 9.95805 25.2777 9.1632 25.2777ZM9.35469 27.7809C9.35469 27.8847 9.26703 27.9724 9.1632 27.9724H6.11125C6.00742 27.9724 5.91977 27.8847 5.91977 27.7809V26.7193C5.91977 26.6155 6.00742 26.5277 6.11125 26.5277H9.1632C9.26703 26.5277 9.35469 26.6155 9.35469 26.7193V27.7809ZM9.1632 19.5516H6.11125C5.31641 19.5516 4.66977 20.1982 4.66977 20.9931V22.0547C4.66977 22.8496 5.31641 23.4963 6.11125 23.4963H9.1632C9.95805 23.4963 10.6047 22.8496 10.6047 22.0547V20.9931C10.6047 20.1982 9.95805 19.5516 9.1632 19.5516ZM9.35469 22.0547C9.35469 22.1585 9.26703 22.2463 9.1632 22.2463H6.11125C6.00742 22.2463 5.91977 22.1585 5.91977 22.0547V20.9931C5.91977 20.8893 6.00742 20.8016 6.11125 20.8016H9.1632C9.26703 20.8016 9.35469 20.8893 9.35469 20.9931V22.0547ZM17.3108 26.7193C17.3108 25.9244 16.6641 25.2777 15.8692 25.2777H12.8173C12.0224 25.2777 11.3758 25.9244 11.3758 26.7193V27.7809C11.3758 28.5758 12.0224 29.2224 12.8173 29.2224H15.8692C16.6641 29.2224 17.3108 28.5758 17.3108 27.7809V26.7193ZM16.0608 27.7809C16.0608 27.8847 15.973 27.9724 15.8692 27.9724H12.8173C12.7134 27.9724 12.6258 27.8847 12.6258 27.7809V26.7193C12.6258 26.6155 12.7134 26.5277 12.8173 26.5277H15.8692C15.973 26.5277 16.0608 26.6155 16.0608 26.7193V27.7809ZM9.1632 13.8255H6.11125C5.31641 13.8255 4.66977 14.4721 4.66977 15.267V16.3285C4.66977 17.1234 5.31641 17.7701 6.11125 17.7701H9.1632C9.95805 17.7701 10.6047 17.1234 10.6047 16.3285V15.267C10.6047 14.4721 9.95805 13.8255 9.1632 13.8255ZM9.35469 16.3285C9.35469 16.4323 9.26703 16.5201 9.1632 16.5201H6.11125C6.00742 16.5201 5.91977 16.4323 5.91977 16.3285V15.267C5.91977 15.1631 6.00742 15.0755 6.11125 15.0755H9.1632C9.26703 15.0755 9.35469 15.1631 9.35469 15.267V16.3285ZM12.8173 23.4963H15.8692C16.6641 23.4963 17.3108 22.8496 17.3108 22.0547V20.9931C17.3108 20.1982 16.6641 19.5516 15.8692 19.5516H12.8173C12.0224 19.5516 11.3758 20.1982 11.3758 20.9931V22.0547C11.3757 22.8496 12.0224 23.4963 12.8173 23.4963ZM12.6257 20.9931C12.6257 20.8893 12.7134 20.8016 12.8172 20.8016H15.8691C15.973 20.8016 16.0607 20.8893 16.0607 20.9931V22.0547C16.0607 22.1585 15.973 22.2463 15.8691 22.2463H12.8172C12.7134 22.2463 12.6257 22.1585 12.6257 22.0547V20.9931ZM38.5778 24.7853C37.4369 22.7821 35.6971 20.518 33.139 17.7122C33.8487 17.3414 34.3346 16.5985 34.3346 15.7438C34.3346 14.6049 33.4721 13.664 32.3662 13.5388L33.9247 11.9802C34.8073 11.0974 34.8073 9.66125 33.9246 8.77859C33.1775 8.03164 31.9895 7.90406 31.1 8.475C31.0329 8.51828 30.973 8.52367 30.8991 8.49289C30.8255 8.46242 30.7868 8.41609 30.7698 8.3382C30.5535 7.34758 29.6887 6.61945 28.6866 6.56117V4.17711C28.6865 1.87383 26.8127 0 24.5095 0H4.17703C1.87375 0 0 1.87383 0 4.17711V30.1437C0 32.447 1.87375 34.3208 4.17703 34.3208H18.2488C18.3078 34.4295 18.3684 34.5378 18.4321 34.6452C20.3976 37.9616 24.1841 40.0002 28.3523 40H28.763C32.931 40 36.7179 37.9614 38.6832 34.6452C40.4688 31.632 40.4305 28.0382 38.5778 24.7853ZM33.0845 15.7438C33.0845 16.2785 32.6495 16.7135 32.1148 16.7135H25.0005C24.4657 16.7135 24.0307 16.2785 24.0307 15.7438C24.0307 15.2091 24.4657 14.7741 25.0005 14.7741H32.1148C32.6495 14.7741 33.0845 15.2092 33.0845 15.7438ZM29.5485 8.605C29.6527 9.08141 29.9705 9.46148 30.4206 9.64781C30.8709 9.83477 31.3648 9.79055 31.7752 9.52703C32.1738 9.27133 32.7062 9.32812 33.0408 9.66266C33.231 9.85289 33.3357 10.1073 33.3357 10.3795C33.3357 10.6516 33.2309 10.9061 33.0407 11.0963L30.613 13.5242H26.5025L24.0746 11.0963C23.8843 10.9061 23.7796 10.6516 23.7796 10.3795C23.7796 10.1073 23.8844 9.85289 24.0746 9.66266C24.409 9.32805 24.9412 9.27094 25.3403 9.52703C25.7507 9.79039 26.2443 9.83438 26.6946 9.64797C27.145 9.46141 27.4629 9.08125 27.5669 8.60484C27.668 8.1418 28.0848 7.8057 28.5577 7.80562C29.0307 7.80555 29.4473 8.14172 29.5485 8.605ZM22.5724 9.93656H5.36102C5.25719 9.93656 5.16945 9.84883 5.16945 9.745V6.53992C5.16945 6.43609 5.25719 6.34844 5.36102 6.34844H23.3254C23.4292 6.34844 23.517 6.43609 23.517 6.53992V8.51062C23.4015 8.58883 23.2918 8.67758 23.1906 8.77875C22.8702 9.09906 22.658 9.49984 22.5724 9.93656ZM4.17703 33.0708C2.56305 33.0708 1.25 31.7577 1.25 30.1437V4.17711C1.25 2.56312 2.56305 1.25 4.17703 1.25H24.5095C26.1234 1.25 27.4365 2.56312 27.4365 4.17711V6.85758C26.8947 7.16937 26.4852 7.69938 26.3457 8.33828C26.3286 8.41625 26.2899 8.46258 26.2164 8.49297C26.1427 8.52375 26.0827 8.51813 26.0154 8.47508C25.6346 8.2307 25.1992 8.11531 24.767 8.12062V6.53992C24.767 5.74508 24.1204 5.09844 23.3255 5.09844H5.36102C4.56609 5.09844 3.91945 5.74508 3.91945 6.53992V9.74492C3.91945 10.5398 4.56609 11.1865 5.36102 11.1865H22.677C22.7888 11.4812 22.9618 11.7512 23.1906 11.9802L24.7493 13.5388C24.2559 13.5946 23.8112 13.8128 23.4698 14.1386C23.2237 13.9431 22.9132 13.8254 22.5752 13.8254H19.5234C18.7284 13.8254 18.0818 14.472 18.0818 15.2669V16.3284C18.0818 17.1234 18.7284 17.77 19.5234 17.77H22.5752C22.9419 17.77 23.2759 17.6313 23.5306 17.4051C23.6656 17.5247 23.8152 17.6279 23.9763 17.7121C23.3926 18.3523 22.8516 18.9643 22.3505 19.5515H19.5233C18.7284 19.5515 18.0817 20.1981 18.0817 20.993V22.0547C18.0817 22.7872 18.6313 23.3926 19.3396 23.4832C19.0445 23.9305 18.7775 24.3638 18.5374 24.7853C16.998 27.4881 16.7126 30.4259 17.6838 33.0708H4.17703ZM22.7668 15.267V16.3285C22.7668 16.4323 22.6791 16.5201 22.5752 16.5201H19.5234C19.4195 16.5201 19.3318 16.4323 19.3318 16.3285V15.267C19.3318 15.1631 19.4195 15.0755 19.5234 15.0755H22.5752C22.6791 15.0755 22.7668 15.1631 22.7668 15.267ZM20.2024 22.2463H19.5234C19.4195 22.2463 19.3318 22.1585 19.3318 22.0547V20.9931C19.3318 20.8893 19.4195 20.8016 19.5234 20.8016H21.314C20.913 21.3005 20.5431 21.7813 20.2024 22.2463ZM37.6079 34.0079C35.8673 36.945 32.4914 38.75 28.7632 38.75C28.6947 38.75 28.4206 38.75 28.3521 38.75C24.6242 38.75 21.2479 36.9448 19.5074 34.0079C17.9342 31.3533 17.9755 28.2977 19.6235 25.4039C20.796 23.3454 22.6483 20.9767 25.443 17.9636H31.672C34.4668 20.9767 36.3191 23.3455 37.4916 25.4039C39.1397 28.2977 39.181 31.3533 37.6079 34.0079ZM31.9006 30.3005C31.9838 30.9861 31.7998 31.6122 31.3684 32.111C30.8774 32.6787 30.0712 33.0634 29.1523 33.1827V33.8163C29.1523 34.1615 28.8724 34.4413 28.5273 34.4413C28.1821 34.4413 27.9023 34.1615 27.9023 33.8163V33.1734C26.5286 32.9625 25.4648 32.0801 25.1527 30.8284C25.0692 30.4934 25.273 30.1542 25.6079 30.0707C25.9428 29.9877 26.282 30.191 26.3655 30.5259C26.6288 31.5821 27.6669 31.9616 28.5201 31.9717C28.5281 31.9714 28.5363 31.9716 28.5443 31.9719C28.572 31.9719 28.5984 31.9718 28.6251 31.971C29.3767 31.9531 30.0823 31.687 30.423 31.2933C30.623 31.062 30.7005 30.7866 30.6598 30.4513C30.5618 29.644 29.8753 29.1784 28.4339 28.9417C26.0297 28.547 25.4693 27.3182 25.4227 26.3567C25.358 25.0252 26.2872 23.91 27.7349 23.5816C27.79 23.5691 27.8459 23.5579 27.9023 23.5479V22.8957C27.9023 22.5505 28.1822 22.2707 28.5273 22.2707C28.8725 22.2707 29.1523 22.5505 29.1523 22.8957V23.5425C30.1606 23.7099 31.1462 24.3072 31.644 25.4927C31.7777 25.8109 31.628 26.1773 31.3097 26.3109C30.992 26.4445 30.6252 26.295 30.4915 25.9766C30.1226 25.0982 29.3323 24.7411 28.5685 24.7391C28.5461 24.7405 28.5233 24.7408 28.5004 24.7398C28.334 24.744 28.1695 24.7648 28.0115 24.8006C27.3359 24.9538 26.6291 25.4272 26.6712 26.2961C26.6859 26.5965 26.7246 27.3944 28.6365 27.7081C29.3807 27.8304 31.6459 28.2023 31.9006 30.3005Z"
                          fill="white"
                        />
                      </g>
                      <defs>
                        <clipPath id="clip0_5698_114373">
                          <rect width="40" height="40" fill="white" />
                        </clipPath>
                      </defs>
                    </svg>
                  </div>
                  <div className="icon-content">
                    <h5>
                      <Link to="jobs-single.html">Accounting</Link>
                    </h5>
                  </div>
                </div>
                <div className="sl-icon-box box">
                  <div className="icon">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="40"
                      height="40"
                      viewBox="0 0 40 40"
                      fill="none"
                    >
                      <g clipPath="url(#clip0_5700_114376)">
                        <path
                          d="M13.6121 24.8785H11.2665C10.5359 24.8785 9.94141 24.2844 9.94141 23.5535V22.2461C9.94141 22.1689 9.88678 22.1021 9.80591 22.0798C8.99261 21.8582 8.20831 21.5323 7.47498 21.1115C7.40845 21.0733 7.33002 21.0809 7.28027 21.1307L6.34644 22.0645C6.09619 22.3148 5.76355 22.4524 5.40955 22.4524C5.05585 22.4524 4.7229 22.3148 4.47266 22.0645L2.81403 20.4059C2.56378 20.1556 2.42584 19.8227 2.42584 19.469C2.42584 19.115 2.56378 18.782 2.81403 18.5321L3.74756 17.5983C3.79761 17.5485 3.80524 17.4701 3.76678 17.4036C3.34625 16.6702 3.02032 15.8859 2.79877 15.0726C2.77649 14.9918 2.70966 14.9371 2.63245 14.9371H1.32507C0.594482 14.9371 0 14.3427 0 13.6121V11.2665C0 10.5359 0.594482 9.94141 1.32507 9.94141H2.63245C2.70966 9.94141 2.77649 9.88708 2.79877 9.80591C3.02032 8.99292 3.34625 8.20862 3.76709 7.47498C3.80524 7.40845 3.79761 7.33002 3.74786 7.28027L2.81403 6.34644C2.56378 6.0965 2.42584 5.76355 2.42584 5.40955C2.42584 5.05585 2.56378 4.7229 2.81403 4.47266L4.47266 2.81403C4.7229 2.56378 5.05554 2.42615 5.40955 2.42615C5.76355 2.42615 6.0965 2.56378 6.34674 2.81433L7.28027 3.74786C7.33002 3.79761 7.40814 3.80524 7.47498 3.76709C8.20831 3.34625 8.99231 3.02063 9.8056 2.79877C9.88708 2.77649 9.94141 2.70966 9.94141 2.63245V1.32507C9.94141 0.594482 10.5359 0 11.2665 0H13.6121C14.3427 0 14.9371 0.594482 14.9371 1.32507V2.63245C14.9371 2.70966 14.9915 2.77649 15.0726 2.79846C15.8856 3.02032 16.6699 3.34625 17.4033 3.76709C17.4701 3.80524 17.5482 3.79761 17.5983 3.74786L18.5318 2.81403C19.0497 2.29645 19.888 2.29614 20.4059 2.81433L20.5814 2.98981C21.1292 3.53729 20.3012 4.36676 19.7528 3.81836C19.6448 3.72498 19.5062 3.49701 19.3607 3.64288L18.4268 4.57642C18.0045 4.99878 17.3438 5.08392 16.8201 4.78333C16.1731 4.41223 15.4813 4.12476 14.7644 3.92914C14.176 3.76892 13.765 3.23547 13.765 2.63214V1.32507C13.765 1.24054 13.6963 1.17188 13.6118 1.17188H11.2662C11.1819 1.17188 11.1133 1.24054 11.1133 1.32507V2.63245C11.1133 3.23578 10.7022 3.76892 10.1138 3.92944C9.39667 4.12506 8.70483 4.41223 8.05786 4.78333C7.53448 5.08392 6.87378 4.99878 6.45142 4.57642L5.51788 3.64288C5.48065 3.60565 5.43854 3.59802 5.40955 3.59802C5.38055 3.59802 5.33844 3.60565 5.30151 3.64288L3.64258 5.30151C3.60565 5.33844 3.59772 5.38086 3.59772 5.40955C3.59772 5.43854 3.60565 5.48096 3.64258 5.51788L4.57642 6.45172C4.99878 6.87408 5.08392 7.53448 4.78333 8.05817C4.41223 8.70544 4.12476 9.39697 3.92914 10.1141C3.76892 10.7025 3.23547 11.1133 2.63245 11.1133H1.32507C1.24054 11.1133 1.17188 11.1823 1.17188 11.2665V13.6121C1.17188 13.6966 1.24054 13.7653 1.32507 13.7653H2.63245C3.23547 13.7653 3.76892 14.176 3.92944 14.7644C4.12476 15.4819 4.41223 16.1734 4.78333 16.8204C5.08392 17.3441 4.99878 18.0045 4.57642 18.4268L3.64288 19.3607C3.60565 19.3976 3.59802 19.44 3.59802 19.469C3.59802 19.4977 3.60596 19.5401 3.64288 19.5773L5.30151 21.2357C5.36133 21.2955 5.45837 21.2958 5.51819 21.2357L6.45172 20.3021C6.87408 19.8798 7.53479 19.7946 8.05847 20.0952C8.70544 20.4663 9.39697 20.7538 10.1141 20.9494C10.7025 21.1096 11.1136 21.6431 11.1136 22.2464V23.5535C11.1136 23.638 11.1823 23.7067 11.2665 23.7067H13.6121C13.6966 23.7067 13.7653 23.638 13.7653 23.5535V22.2464C13.7653 21.6431 14.1763 21.1096 14.7647 20.9494C15.5133 20.7455 15.8203 21.8762 15.0729 22.0798C14.9918 22.1021 14.9371 22.1689 14.9371 22.2464V23.5535C14.9371 24.2841 14.3427 24.8785 13.6121 24.8785Z"
                          fill="white"
                        />
                        <path
                          d="M6.91699 12.4394C6.91699 8.56487 10.8129 5.90893 14.403 7.27673C15.1265 7.55291 14.7106 8.64819 13.9855 8.372C11.1522 7.29199 8.08856 9.39526 8.08856 12.4394C8.08856 14.9156 10.1741 16.9304 12.6992 16.7823C13.4713 16.7357 13.5436 17.9066 12.7681 17.9524C9.58423 18.1398 6.91699 15.6007 6.91699 12.4394Z"
                          fill="white"
                        />
                        <path
                          d="M32.425 26.0196L26.4881 24.8651V23.3981C28.1553 22.2607 29.058 20.65 29.2545 18.8409C30.12 18.7723 30.803 18.0463 30.803 17.1637V15.9595C32.2138 15.3461 32.0234 13.287 30.5308 12.9398V12.475C30.5308 8.2962 27.143 4.90845 22.9645 4.90845H22.3301C18.1513 4.90845 14.7639 8.2962 14.7639 12.4747V12.9398C13.2719 13.2867 13.0802 15.3461 14.4916 15.9595V17.1637C14.4916 18.0463 15.1746 18.7723 16.0401 18.8409C16.2116 20.4193 16.9514 21.864 18.1183 22.8687C18.3417 23.0612 18.5712 23.2376 18.8065 23.3981V24.8651L12.8696 26.0196C9.7373 26.6287 7.2959 28.3945 7.2959 31.6525V37.6123C7.2959 38.931 8.36493 40 9.68359 40H35.611C36.9297 40 37.9987 38.931 37.9987 37.6123V31.6525C37.9987 28.4052 35.5723 26.6315 32.425 26.0196ZM27.548 26.265C27.1226 26.8835 26.4722 27.8278 25.7697 28.8446C25.4835 29.2593 24.9698 29.3121 24.769 29.1919L23.8434 28.6368C24.7462 28.1036 25.9952 27.1881 26.3743 26.0367L27.548 26.265ZM22.6472 27.9535C21.7573 27.5055 19.9833 26.3986 19.9784 25.3525C19.9784 25.351 19.9784 25.3494 19.9784 25.3479V24.0451C21.6837 24.7806 23.6088 24.7815 25.3162 24.0451V25.3479C25.3162 26.3959 23.538 27.5052 22.6472 27.9535ZM15.9357 12.4747C15.9357 10.0711 17.2687 7.97302 19.2344 6.8811V7.61566C19.2344 8.3902 20.4062 8.39142 20.4062 7.61566V6.37604C20.9321 6.20972 21.4869 6.10992 22.0612 6.08612V8.98346C22.0612 9.758 23.2331 9.75922 23.2331 8.98346V6.08612C23.8074 6.10992 24.3625 6.20972 24.8884 6.37604V7.61566C24.8884 8.3902 26.0602 8.39142 26.0602 7.61566V6.8811C28.0259 7.97302 29.3589 10.0711 29.3589 12.4747V12.8983H15.9357V12.4747ZM15.1258 14.0701H30.1688C30.7303 14.0701 30.7297 14.9188 30.1688 14.9188H15.1258C14.564 14.9188 14.5646 14.0701 15.1258 14.0701ZM17.1747 18.2477C17.168 17.9291 16.9077 17.6743 16.5888 17.6743C16.4911 17.6501 15.6632 17.8265 15.6632 17.1637V16.091H29.6311V17.1637C29.6311 17.8253 28.7812 17.6556 28.7055 17.6743C28.3869 17.6743 28.1266 17.9291 28.1196 18.2477C28.0881 19.7125 27.4656 21.073 26.4118 21.9806C24.174 23.9075 21.1207 23.9078 18.8828 21.9806C17.8287 21.073 17.2062 19.7125 17.1747 18.2477ZM18.92 26.0367C19.2994 27.1881 20.5482 28.1036 21.4512 28.6368C20.5234 29.1336 20.5891 29.2822 20.1676 29.2325C19.9055 29.201 19.6702 29.0552 19.52 28.8379C18.8193 27.8235 18.1711 26.882 17.7463 26.265L18.92 26.0367ZM12.1595 38.8281H9.68329C9.0119 38.8281 8.46747 38.2837 8.46747 37.6123V31.6525C8.46747 29.8965 9.2652 28.6826 11.0151 27.8439C11.0859 28.1558 12.1595 31.0699 12.1595 35.1419V38.8281ZM22.0612 38.8281H13.3314V35.1419C13.3314 30.73 12.2175 27.8891 12.1079 27.4081C12.7921 27.1808 12.284 27.356 16.4921 26.5088C17.7015 28.2663 19.9586 31.5454 21.2891 33.4366C21.7945 34.1547 22.0612 34.9982 22.0612 35.8762V38.8281ZM22.6472 33.4256C22.5306 33.197 22.3972 32.9755 22.2477 32.7625C21.7979 32.1234 21.2141 31.2848 20.6049 30.4056C20.7859 30.3656 20.9626 30.296 21.1283 30.1968L22.6472 29.2859L24.1663 30.1968C24.3317 30.296 24.5087 30.3656 24.6897 30.4056C24.0806 31.2842 23.4968 32.1228 23.0469 32.7625C22.8971 32.9755 22.7637 33.197 22.6472 33.4256ZM36.8268 37.6123C36.8268 38.2837 36.2827 38.8281 35.611 38.8281H33.1348V36.6174C33.1348 35.8429 31.963 35.8417 31.963 36.6174V38.8281H23.2331V35.8762C23.2331 34.9982 23.5001 34.1547 24.0052 33.4369C24.762 32.3611 27.8782 27.8644 28.8026 26.5088C33.0085 27.3557 32.5013 27.1805 33.1864 27.4081C33.1013 27.7686 32.1152 30.4483 31.9791 34.2496C31.951 35.0259 33.1223 35.0641 33.1501 34.2917C33.2819 30.6131 34.1843 28.2462 34.2792 27.8439C36.0291 28.6826 36.8268 29.8965 36.8268 31.6522V37.6123Z"
                          fill="white"
                        />
                      </g>
                      <defs>
                        <clipPath id="clip0_5700_114376">
                          <rect width="40" height="40" fill="white" />
                        </clipPath>
                      </defs>
                    </svg>
                  </div>
                  <div className="icon-content">
                    <h5>
                      <Link to="jobs-single.html">Engineering</Link>
                    </h5>
                  </div>
                </div>
                <div className="sl-icon-box box">
                  <div className="icon">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="40"
                      height="40"
                      viewBox="0 0 40 40"
                      fill="none"
                    >
                      <g clipPath="url(#clip0_5700_114549)">
                        <path
                          d="M32.3125 8.3125C24.9844 0.984375 13.1328 0.984375 5.80469 8.3125C2.26563 11.8516 0.320312 16.5547 0.320312 21.5625C0.320312 31.9219 8.70312 40.3125 19.0625 40.3125C24.0703 40.3125 28.7734 38.3594 32.3125 34.8203C39.6406 27.4922 39.6406 15.6328 32.3125 8.3125ZM34.7344 14.5391H29.1328C28.7891 12.8359 27.3359 11.5703 25.6406 11.4297C25.6406 11.3594 25.6328 11.2891 25.6172 11.2109C24.8594 8.375 23.8281 6.1875 22.6172 4.75C28.0312 5.89844 32.5156 9.60156 34.7344 14.5391ZM19.0625 38.75C17.2578 38.75 15.4297 36.2734 14.2188 32.2422C15.4453 31.7656 16.3672 30.6953 16.6406 29.3828H24.6016C24.2891 31.0078 23.8594 32.5625 23.3047 33.9922C22.1172 37.0078 20.5703 38.75 19.0625 38.75ZM24.1016 11.6016C22.75 12.0391 21.7578 13.1719 21.4844 14.5312C14.2344 14.5312 15.1406 14.5312 15.0625 14.5391C14.8672 13.7891 14.3984 13.125 13.75 12.7031C14.3203 10.1953 15.125 8.10156 16.0781 6.61719C19.3203 1.59375 22.5469 5.82812 24.1016 11.6016ZM12.5547 13.8438C13.1797 14.0625 13.5938 14.6562 13.5938 15.3203C13.5938 16.1797 12.8906 16.8828 12.0312 16.8828C11.1719 16.8828 10.4688 16.1797 10.4688 15.3203C10.4688 14.2422 11.5391 13.4844 12.5547 13.8438ZM12.8125 26.25C14.1016 26.25 15.1562 27.3047 15.1562 28.5938C15.1562 29.8828 14.1094 30.9375 12.8125 30.9375C11.5234 30.9375 10.4688 29.8828 10.4688 28.5938C10.4688 27.3047 11.5234 26.25 12.8125 26.25ZM16.6406 27.8125C16.2812 26.0703 14.7578 24.7422 12.9219 24.6875C12.7812 22.6484 12.7734 20.4922 12.9297 18.3047C13.9688 17.9922 14.7891 17.1484 15.0547 16.0859C15.1406 16.0937 17.2578 16.0938 21.4766 16.0938C21.8359 17.8516 23.3828 19.1875 25.2422 19.2188C25.3828 21.9297 25.2891 24.9297 24.8594 27.8125H16.6406ZM25.3047 17.6562C24.0156 17.6562 22.9609 16.6016 22.9609 15.3125C22.9609 14.2422 23.6797 13.3125 24.7188 13.0469C26.2031 12.6641 27.6484 13.7891 27.6484 15.3125C27.6484 16.6094 26.6016 17.6562 25.3047 17.6562ZM15.5156 4.75C14.1562 6.35156 13.0312 8.89844 12.2578 12.1953C10.7656 12.0859 9.375 13.0781 9.00781 14.5312H3.38281C5.60938 9.60156 10.0938 5.89062 15.5156 4.75ZM2.77344 16.0938H9.00781C9.29688 17.2266 10.2109 18.1094 11.3594 18.3672C11.2031 20.5703 11.2188 22.8203 11.375 24.9609C10.1641 25.4453 9.25 26.5078 8.98438 27.8125H3.05469C1.58594 24.0625 1.49219 19.8906 2.77344 16.0938ZM3.75781 29.375H8.98438C9.33594 31.1094 10.8438 32.4297 12.6641 32.4922C13.4062 35.0469 14.375 37.0391 15.5078 38.375C10.3828 37.2969 6.08594 33.9141 3.75781 29.375ZM22.6016 38.375C24.5469 36.0781 25.6406 32.3281 26.1875 29.3672H34.3594C32.0312 33.9219 27.7344 37.2969 22.6016 38.375ZM35.0625 27.8125H26.4453C26.8672 24.8359 26.9609 21.75 26.7969 18.9297C27.9844 18.4375 28.875 17.3828 29.1328 16.1016H35.3516C36.625 19.8828 36.5391 24.0547 35.0625 27.8125Z"
                          fill="white"
                        />
                      </g>
                      <defs>
                        <clipPath id="clip0_5700_114549">
                          <rect width="40" height="40" fill="white" />
                        </clipPath>
                      </defs>
                    </svg>
                  </div>
                  <div className="icon-content">
                    <h5>
                      <Link to="jobs-single.html">IT & Networking</Link>
                    </h5>
                  </div>
                </div>
                <div className="sl-icon-box box">
                  <div className="icon">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="40"
                      height="40"
                      viewBox="0 0 40 40"
                      fill="none"
                    >
                      <path
                        d="M10.7003 24.0808C11.0738 23.8653 11.2017 23.3871 10.9863 23.0136C10.7705 22.6403 10.2926 22.5122 9.91905 22.7276C9.54552 22.9434 9.41734 23.4216 9.6331 23.7948C9.84856 24.1684 10.3268 24.2965 10.7003 24.0808Z"
                        fill="white"
                      />
                      <path
                        d="M7.49877 29.473L11.4331 36.2879C12.2821 37.7601 14.1919 38.3051 15.7022 37.432C17.1966 36.5684 17.7103 34.6589 16.8457 33.1632L14.5019 29.1031L16.5317 27.9313C16.9052 27.7152 17.0334 27.2376 16.8176 26.8641L15.8017 25.1044C15.9228 25.0809 16.7194 24.9247 30.7657 22.1693C32.5021 22.075 33.5425 20.1758 32.6654 18.6576L30.069 14.1605L31.7282 11.6474C31.8912 11.4002 31.9009 11.0825 31.7529 10.8262L30.1904 8.11987C30.0424 7.86353 29.7613 7.71338 29.4668 7.73077L26.4612 7.91113L23.5788 2.91846C23.1613 2.19519 22.4133 1.75726 21.5784 1.74689C21.5683 1.74658 21.5585 1.74658 21.5485 1.74658C20.7416 1.74658 20.0091 2.14819 19.5752 2.82721L9.3695 15.8283L2.73467 19.6589C0.12511 21.1649 -0.778821 24.5127 0.73302 27.1293C2.11425 29.5219 5.02623 30.463 7.49877 29.473ZM15.4928 33.9448C15.9244 34.6912 15.6689 35.6464 14.9203 36.0789C14.1693 36.5131 13.2129 36.2464 12.7862 35.507L8.87999 28.7403L11.5863 27.1778C16.1072 35.0092 15.4202 33.8193 15.4928 33.9448ZM13.7207 27.7497L12.9394 26.3965L14.2926 25.6153L15.0738 26.9684L13.7207 27.7497ZM29.0787 9.31921L30.1584 11.1893L29.1955 12.6475L27.3346 9.42389L29.0787 9.31921ZM20.8819 3.68384C21.0916 3.34082 21.4242 3.30542 21.5591 3.30908C21.6925 3.31061 22.0248 3.35211 22.2253 3.6994L31.3122 19.4388C31.6083 19.9512 31.2485 20.5955 30.6549 20.6101C30.5484 20.6125 30.4993 20.6318 30.2264 20.6827L20.6143 4.03387C20.816 3.77448 20.842 3.74945 20.8819 3.68384ZM19.5746 5.35834L28.6056 21.0007L14.9759 23.6741L10.8316 16.496L19.5746 5.35834ZM2.08617 26.348C1.74315 25.7545 1.56188 25.0806 1.56188 24.3989C1.56188 23.0054 2.31078 21.7078 3.51592 21.012L9.60509 17.4964L13.5113 24.2621L7.42217 27.7781C5.55663 28.8547 3.16313 28.2133 2.08617 26.348Z"
                        fill="white"
                      />
                      <path
                        d="M8.28044 24.576C8.06468 24.2025 7.58678 24.0743 7.21324 24.2901L5.86009 25.0713C5.48717 25.2868 5.00835 25.1583 4.79289 24.7854C4.57713 24.4118 4.09923 24.2837 3.72569 24.4994C3.35216 24.7152 3.22398 25.1931 3.43974 25.5666C4.08275 26.6805 5.51707 27.0733 6.64134 26.4245L7.99449 25.6432C8.36803 25.4275 8.4962 24.9499 8.28044 24.576Z"
                        fill="white"
                      />
                      <path
                        d="M38.8388 3.41769L34.4855 5.84017C34.1086 6.05013 33.9728 6.5259 34.1828 6.90279C34.3921 7.27938 34.8676 7.41579 35.2454 7.20553L39.5984 4.78304C39.9756 4.57308 40.1111 4.09731 39.9011 3.72042C39.6915 3.34322 39.2157 3.20772 38.8388 3.41769Z"
                        fill="white"
                      />
                      <path
                        d="M38.3822 11.5091L35.3637 10.7004C34.9469 10.5887 34.5184 10.8359 34.4067 11.2528C34.295 11.6697 34.5425 12.0978 34.9594 12.2095L37.9782 13.0182C38.3975 13.1308 38.8238 12.8797 38.9349 12.4659C39.0466 12.049 38.7991 11.6205 38.3822 11.5091Z"
                        fill="white"
                      />
                      <path
                        d="M30.7964 0.5792L29.9868 3.598C29.8751 4.01487 30.1223 4.44303 30.5392 4.55503C30.9557 4.66642 31.3842 4.41984 31.4962 4.00266L32.3055 0.983864C32.4172 0.566993 32.17 0.138527 31.7532 0.0268323C31.3366 -0.084862 30.9081 0.16233 30.7964 0.5792Z"
                        fill="white"
                      />
                    </svg>
                  </div>
                  <div className="icon-content">
                    <h5>
                      <Link to="jobs-single.html">Sales & Marketing</Link>
                    </h5>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div className="overlay"></div>
    </section>
  );
}

export default Banner10;
